#include "ConnectionForm.h"
#include "MainForm.h"
#include "TextEdit.h"
#include "DatabaseTree.h"
#include "MainTextEdit.h"

/* 
	  
*/
TextEdit::TextEdit(QWidget* parent) : QTextEdit(parent)
{
	this->completer = new QCompleter();
	this->model = this->ModelFromFile("lists/wordlist.txt");
	this->SetModel(this->model);
	this->mode = false;  // Ϲ Completer
	this->changeModel = false;
}

/* 
	Ͽ Completion  
*/
QAbstractItemModel* TextEdit::ModelFromFile(const QString& fileName)
{
    QFile file(fileName);
    if (!file.open(QFile::ReadOnly))
        return new QStringListModel(completer);

    QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
    QStringList words;
    
    while (!file.atEnd()) {
        QByteArray line = file.readLine();
        if (!line.isEmpty())
            words << line.trimmed();
    }

    QApplication::restoreOverrideCursor();
	QAbstractItemModel* buffer = new QStringListModel(words, completer);
    return buffer;
}

/* 
	QCompleter ü 
*/
void TextEdit::SetModel(QAbstractItemModel* model)
{
	if( this->completer != 0 ){
		 QObject::disconnect(this->completer, 0, this, 0);
	}
	
	this->completer = new QCompleter();

	this->completer->setModel(model);
    this->completer->setModelSorting(QCompleter::CaseInsensitivelySortedModel);
    this->completer->setCaseSensitivity(Qt::CaseInsensitive);
    this->completer->setWrapAround(false);
	this->completer->setWidget(this);
	this->completer->setCompletionMode(QCompleter::PopupCompletion);
	this->completer->setCaseSensitivity(Qt::CaseInsensitive);
	connect(this->completer, SIGNAL(activated(const QString&)), 
		(TextEdit*)this, SLOT(InsertCompletion(const QString&)));
}


/* 
	̺ شϴ QCompleter ü 
*/
void TextEdit::SetTableCompleter(QCompleter* tableCompleter)
{
	if( this->tableCompleter != 0 ){
		QObject::disconnect(tableCompleter, 0, this, 0);
	}

    this->tableCompleter = tableCompleter;

    if (this->tableCompleter != 0){
	    this->tableCompleter->setWidget(this);
		this->tableCompleter->setCompletionMode(QCompleter::PopupCompletion);
		this->tableCompleter->setCaseSensitivity(Qt::CaseInsensitive);
		connect(this->tableCompleter, SIGNAL(activated(const QString&)), 
			(TextEdit*)this, SLOT(InsertCompletion(const QString&)));
	}
}


/* 
	Completion ϼ  Ŀ ġ 
*/
void TextEdit::InsertCompletion(const QString& completion)
{
    if (this->completer->widget() == this){
		QTextCursor textCursor = this->textCursor();
		textCursor.insertText(completion.right(completion.length() - this->completer->completionPrefix().length()));
		setTextCursor(textCursor);
	}
}

/*
	Ű   ̺Ʈ ó
*/
void TextEdit::keyPressEvent(QKeyEvent *e)
{
	// ˾â    ˾â õ Ű 
	if( this->completer->popup()->isVisible() == true ){
		
		if ( e->key() == Qt::Key_Enter || e->key() == Qt::Key_Return || e->key() == Qt::Key_Tab ||
			e->key() == Qt::Key_Escape || e->key() == Qt::Key_Backtab){
			
			e->ignore();
			
			if( this->mode == true && (e->key() == Qt::Key_Enter || e->key() == Qt::Key_Return || e->key() == Qt::Key_Tab)){
				this->changeModel = true;  //  ٲ ...
			} 
		}
		
		else{
			this->ProcessCompletion(e);
		}
	}
	
	// ˾â   ʴ  ˾â 
	else if( this->completer->popup()->isVisible() == false ){
		this->ProcessCompletion(e);
	}
}

/*
	Ű   ̺Ʈ ó
*/
void TextEdit::keyReleaseEvent(QKeyEvent *e)
{
	
	if( this->changeModel == true ){
		this->changeModel = false;
		this->model = this->ModelFromFile("lists/wordlist.txt");
		this->SetModel(this->model);
		this->mode = false;  // ̺  Completer
	}
}

/*
	Completion ó κ
*/
void TextEdit::ProcessCompletion(QKeyEvent *e)
{
	QTextEdit::keyPressEvent(e);
	
	if( !(e->matches(QKeySequence::Cut) || e->matches(QKeySequence::Copy) || e->matches(QKeySequence::Paste)
		|| e->matches(QKeySequence::Undo) || e->matches(QKeySequence::SelectAll))){
		
		QTextCursor cursor = this->textCursor();
		cursor.select(QTextCursor::WordUnderCursor);
		QString prefixWord = cursor.selectedText();
		QString endOfWord("&*()+:\",.;'\\=");

		if( e->text().isEmpty() || prefixWord.length() < 1 || endOfWord.contains(e->text()) ){
			this->completer->popup()->hide();
			
			if( e->text() == "." ){

				cursor.select(QTextCursor::WordUnderCursor);
				QString nameOfTable = cursor.selectedText();
				
				MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();

				QList<QTreeWidgetItem*> list = mainForm->GetFolderView()->findItems(nameOfTable, Qt::MatchWildcard | Qt::MatchRecursive);
				
				QStringList columnList;
				
				if( list.count() != 0){				
					for( int i=0 ; i<list[0]->child(0)->childCount(); i++){
						columnList << list[0]->child(0)->child(i)->text(0);
					}
					
					if( this->completer != 0 ){
						QObject::disconnect(this->completer, 0, this, 0);
					}
					
					this->completer = new QCompleter(columnList, this);
					this->completer->setWrapAround(false);
					this->completer->setWidget(this);
					this->completer->setCompletionMode(QCompleter::PopupCompletion);
					this->completer->setCaseSensitivity(Qt::CaseInsensitive);
					this->mode = true;
					connect(this->completer, SIGNAL(activated(const QString&)), 
						(TextEdit*)this, SLOT(InsertCompletion(const QString&)));
				}

				else{
					this->changeModel = false;
					this->model = this->ModelFromFile("lists/wordlist.txt");
					this->SetModel(this->model);
					this->mode = false;
				}
			}
		}
		
		else {
			
			if (prefixWord != this->completer->completionPrefix()){
				this->completer->setCompletionPrefix(prefixWord);
				this->completer->popup()->setCurrentIndex(this->completer->completionModel()->index(0, 0));
			}
			
			QRect cursorRect = this->cursorRect();
			cursorRect.setWidth(this->completer->popup()->sizeHintForColumn(0) + 
				this->completer->popup()->verticalScrollBar()->sizeHint().width());
			this->completer->complete(cursorRect);
		}
	}
}

/* 
	ڽſ Ŀ   ̺Ʈ ó
*/
void TextEdit::focusInEvent(QFocusEvent *e)
{
    if(this->completer){
        this->completer->setWidget(this);
	}

    QTextEdit::focusInEvent(e);
}

// kang
/* 
	ؽƮ ޴(Ŭ ˾ ޴ )
*/
void TextEdit::contextMenuEvent( QContextMenuEvent *e)
{	
	QMenu* contextMenu = createStandardContextMenu();
	//QMenu* contextMenu =new QMenu(this);

	MainTextEdit* context1 = ((MainTextEdit*)(this->parent()));
	MainForm* context2 = ConnectionForm::getInstance()->GetMainForm();
	
	QAction *actionAction1 = contextMenu->addAction(QIcon("images/breakpoint.png"), tr( "Breakpoint" ) );
	connect( actionAction1, SIGNAL(triggered()), context1, SLOT(slot_setBreakpoint()));
	
	QAction *actionAction2 = contextMenu->addAction( tr( "All Breakpoint Delete" ) );
	connect( actionAction2, SIGNAL(triggered()), context1, SLOT(slot_Allbreakpointclear()));
	
	QAction *actionAction3 = contextMenu->addAction(QIcon("images/continue.png"), tr( "Run" ));
	connect( actionAction3, SIGNAL(triggered()), context2, SLOT(Run()));
	QAction *actionAction4 = contextMenu->addAction(QIcon("images/step_into.png"), tr( "Step_Over" ));
	connect( actionAction4, SIGNAL(triggered()), context2, SLOT(StepInto()));
	
	QAction *actionAction5 = contextMenu->addAction(QIcon("images/stop.png"), tr( "Stop" ));
	connect( actionAction5, SIGNAL(triggered()), context2, SLOT(Stop()));
	contextMenu->exec( e->globalPos() );
}

/* 
	  
*/
TextEdit::~TextEdit()
{
}
